SET FOREIGN_KEY_CHECKS=0;
DROP TABLE IF EXISTS admin;

CREATE TABLE `admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL,
  `password` varchar(40) NOT NULL,
  `activity` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO admin VALUES("8","hekmat","fd484e1d09d14621ee8610f92de26444","active");



DROP TABLE IF EXISTS assetopeningbalance;

CREATE TABLE `assetopeningbalance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currencyUnit` int(11) NOT NULL,
  `amount` decimal(17,6) NOT NULL,
  `rate` decimal(17,6) NOT NULL,
  `totalDollar` decimal(17,6) NOT NULL,
  `bank_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;

INSERT INTO assetopeningbalance VALUES("1","1","1000000.000000","0.000000","0.000000","0");
INSERT INTO assetopeningbalance VALUES("2","2","5000.000000","0.000000","0.000000","0");



DROP TABLE IF EXISTS assets;

CREATE TABLE `assets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` decimal(17,6) NOT NULL,
  `currencies_id` int(11) NOT NULL,
  `dollarAmount` decimal(17,2) NOT NULL,
  `bank_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_assets_currency1_idx` (`currencies_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='				';

INSERT INTO assets VALUES("1","68750.000000","1","0.00","0");
INSERT INTO assets VALUES("2","2500.000000","2","0.00","0");



DROP TABLE IF EXISTS assets_report;

CREATE TABLE `assets_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` decimal(17,6) NOT NULL,
  `currencies_id` int(11) NOT NULL,
  `dollarAmount` decimal(17,2) NOT NULL,
  `bank_id` int(11) NOT NULL,
  `date` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_assets_currency1_idx` (`currencies_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='				';

INSERT INTO assets_report VALUES("1","68750.000000","1","0.00","0","1397-12-08");
INSERT INTO assets_report VALUES("2","2500.000000","2","0.00","0","1397-12-08");



DROP TABLE IF EXISTS bank_statement;

CREATE TABLE `bank_statement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(45) CHARACTER SET latin1 NOT NULL,
  `reference_id` int(11) NOT NULL,
  `reference` varchar(50) COLLATE utf8_persian_ci NOT NULL,
  `bank_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `transaction_type` int(11) NOT NULL,
  `description` text COLLATE utf8_persian_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;




DROP TABLE IF EXISTS banking;

CREATE TABLE `banking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(50) COLLATE utf8_persian_ci NOT NULL,
  `counterCurrency` int(11) NOT NULL,
  `counterAmount` decimal(17,4) NOT NULL,
  `baseCurrency` int(11) NOT NULL,
  `rate` decimal(17,4) NOT NULL,
  `baseAmount` decimal(17,4) NOT NULL,
  `dollarRate` decimal(17,6) NOT NULL,
  `totalDollart` decimal(17,4) NOT NULL,
  `descr` text COLLATE utf8_persian_ci NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;




DROP TABLE IF EXISTS bankregistration;

CREATE TABLE `bankregistration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(45) NOT NULL,
  `bank` varchar(100) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `openingBalance` decimal(10,2) NOT NULL,
  `description` text NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS crrencyrate;

CREATE TABLE `crrencyrate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `counterCurrency` varchar(40) COLLATE utf8_persian_ci NOT NULL,
  `baseCurrency` varchar(40) COLLATE utf8_persian_ci NOT NULL,
  `unit` int(11) NOT NULL,
  `rate` decimal(10,3) NOT NULL,
  `date` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `time` varchar(50) COLLATE utf8_persian_ci NOT NULL,
  `type` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;

INSERT INTO crrencyrate VALUES("1","2","2","1","1.000","1397-11-16","17:42:02","1");
INSERT INTO crrencyrate VALUES("2","2","1","1","75.000","1397-11-16","17:46:42","1");
INSERT INTO crrencyrate VALUES("3","3","2","1","1.140","1397-11-16","17:46:55","1");
INSERT INTO crrencyrate VALUES("4","2","4","1","140.000","1397-11-16","17:47:05","1");
INSERT INTO crrencyrate VALUES("5","2","5","1","11000.000","1397-11-16","17:47:15","1");
INSERT INTO crrencyrate VALUES("6","5","1","1000","6.300","1397-11-16","17:50:05","1");
INSERT INTO crrencyrate VALUES("7","2","1","1","75.700","1397-11-20","17:25:27","1");
INSERT INTO crrencyrate VALUES("8","2","2","1","1.000","1397-11-20","17:25:37","1");
INSERT INTO crrencyrate VALUES("9","3","2","1","1.145","1397-11-20","17:25:54","1");
INSERT INTO crrencyrate VALUES("10","2","4","1","138.000","1397-11-20","17:26:04","1");
INSERT INTO crrencyrate VALUES("11","2","5","1","11000.000","1397-11-20","17:26:18","1");
INSERT INTO crrencyrate VALUES("12","2","1","1","75.700","1397-11-19","13:33:23","1");
INSERT INTO crrencyrate VALUES("13","2","2","1","1.000","1397-11-19","13:34:07","1");
INSERT INTO crrencyrate VALUES("14","3","2","1","1.145","1397-11-19","13:34:44","1");
INSERT INTO crrencyrate VALUES("15","5","2","1","11000.000","1397-11-19","13:35:55","1");
INSERT INTO crrencyrate VALUES("16","2","1","1","75.700","1397-11-19","13:37:11","1");
INSERT INTO crrencyrate VALUES("17","2","2","1","1.000","1397-11-19","13:39:03","1");
INSERT INTO crrencyrate VALUES("18","3","2","1","1.145","1397-11-19","13:39:37","1");
INSERT INTO crrencyrate VALUES("19","2","4","1","138.000","1397-11-19","13:40:17","1");
INSERT INTO crrencyrate VALUES("20","4","2","1","138.000","1397-11-19","13:41:24","1");
INSERT INTO crrencyrate VALUES("21","2","5","1","11000.000","1397-11-19","13:42:21","1");
INSERT INTO crrencyrate VALUES("22","1","2","1","75.700","1397-11-19","13:43:26","1");
INSERT INTO crrencyrate VALUES("23","2","1","1","75.700","1397-11-18","13:50:24","1");
INSERT INTO crrencyrate VALUES("24","3","2","1","1.145","1397-11-18","13:50:46","1");
INSERT INTO crrencyrate VALUES("25","2","4","1","138.000","1397-11-18","13:51:03","1");
INSERT INTO crrencyrate VALUES("26","2","5","1","11000.000","1397-11-18","13:51:21","1");
INSERT INTO crrencyrate VALUES("27","2","2","1","1.000","1397-11-20","14:59:51","1");
INSERT INTO crrencyrate VALUES("28","3","2","1","1.145","1397-11-20","15:00:14","1");
INSERT INTO crrencyrate VALUES("29","2","1","1","75.700","1397-11-20","15:00:31","1");
INSERT INTO crrencyrate VALUES("30","2","4","1","138.000","1397-11-20","15:00:58","1");
INSERT INTO crrencyrate VALUES("31","2","5","1","11000.000","1397-11-20","15:01:30","1");
INSERT INTO crrencyrate VALUES("32","2","1","1","75.700","1397-11-23","17:08:18","1");
INSERT INTO crrencyrate VALUES("33","2","5","1","11000.000","1397-11-23","17:09:18","1");
INSERT INTO crrencyrate VALUES("34","2","4","1","138.000","1397-11-23","17:09:45","1");
INSERT INTO crrencyrate VALUES("35","3","2","1","0.145","1397-11-23","17:10:18","1");
INSERT INTO crrencyrate VALUES("36","3","2","1","1.145","1397-11-23","17:11:08","1");
INSERT INTO crrencyrate VALUES("37","3","4","1","159.155","1397-11-20","13:08:01","1");
INSERT INTO crrencyrate VALUES("38","4","1","1000","529.000","1397-11-20","13:11:34","1");
INSERT INTO crrencyrate VALUES("39","3","1","1","82.266","1397-11-21","13:57:38","1");
INSERT INTO crrencyrate VALUES("40","2","2","1","1.000","1397-11-23","16:01:05","1");
INSERT INTO crrencyrate VALUES("41","3","2","1","1.145","1397-11-23","16:01:20","1");
INSERT INTO crrencyrate VALUES("42","2","1","1","75.700","1397-11-23","16:01:37","1");
INSERT INTO crrencyrate VALUES("43","2","5","1","11000.000","1397-11-23","16:01:51","1");
INSERT INTO crrencyrate VALUES("44","2","4","1","138.000","1397-11-23","16:02:05","1");
INSERT INTO crrencyrate VALUES("45","2","2","1","1.000","1397-11-25","23:31:22","1");
INSERT INTO crrencyrate VALUES("46","2","1","1","75.700","1397-11-25","23:31:38","1");
INSERT INTO crrencyrate VALUES("47","2","4","1","138.000","1397-11-25","23:31:54","1");
INSERT INTO crrencyrate VALUES("48","2","5","1","11000.000","1397-11-25","23:32:11","1");
INSERT INTO crrencyrate VALUES("49","3","2","1","1.145","1397-11-25","23:32:29","1");
INSERT INTO crrencyrate VALUES("50","2","2","1","1.000","1397-11-27","01:53:57","1");
INSERT INTO crrencyrate VALUES("51","3","2","1","1.145","1397-11-27","01:54:13","1");
INSERT INTO crrencyrate VALUES("52","2","1","1","75.700","1397-11-27","01:54:25","1");
INSERT INTO crrencyrate VALUES("53","2","4","1","138.000","1397-11-27","01:54:40","1");
INSERT INTO crrencyrate VALUES("54","2","5","1","11000.000","1397-11-27","01:54:55","1");
INSERT INTO crrencyrate VALUES("55","2","2","1","1.000","1397-11-28","15:01:30","1");
INSERT INTO crrencyrate VALUES("56","2","1","1","75.700","1397-11-28","15:02:33","1");
INSERT INTO crrencyrate VALUES("57","2","3","1","1.145","1397-11-28","15:02:58","1");
INSERT INTO crrencyrate VALUES("58","3","2","1","1.145","1397-11-28","15:03:18","1");
INSERT INTO crrencyrate VALUES("59","2","5","1","11000.000","1397-11-28","15:03:32","1");
INSERT INTO crrencyrate VALUES("60","2","4","1","138.000","1397-11-28","15:03:53","1");
INSERT INTO crrencyrate VALUES("61","2","2","1","1.000","1397-11-29","16:35:11","1");
INSERT INTO crrencyrate VALUES("62","2","1","1","75.700","1397-11-29","16:35:28","1");
INSERT INTO crrencyrate VALUES("63","2","4","1","138.000","1397-11-29","16:35:43","1");
INSERT INTO crrencyrate VALUES("64","2","5","1","11000.000","1397-11-29","16:36:12","1");
INSERT INTO crrencyrate VALUES("65","2","3","1","1.145","1397-11-29","16:37:25","1");
INSERT INTO crrencyrate VALUES("66","3","2","1","1.145","1397-11-29","16:37:46","1");
INSERT INTO crrencyrate VALUES("67","2","2","1","1.000","1397-11-30","13:17:28","1");
INSERT INTO crrencyrate VALUES("68","2","1","1","75.700","1397-11-30","13:17:49","1");
INSERT INTO crrencyrate VALUES("69","2","4","1","138.000","1397-11-30","13:18:02","1");
INSERT INTO crrencyrate VALUES("70","3","2","1","1.145","1397-11-30","13:18:14","1");
INSERT INTO crrencyrate VALUES("71","2","5","1","11000.000","1397-11-30","13:18:25","1");
INSERT INTO crrencyrate VALUES("72","2","3","1","1.145","1397-11-30","13:18:40","1");
INSERT INTO crrencyrate VALUES("73","3","5","1","15000.000","1397-11-29","18:18:01","1");
INSERT INTO crrencyrate VALUES("74","2","2","1","1.000","1397-12-01","16:26:32","1");
INSERT INTO crrencyrate VALUES("75","3","2","1","1.145","1397-12-01","16:27:07","1");
INSERT INTO crrencyrate VALUES("76","2","1","1","75.700","1397-12-01","16:27:35","1");
INSERT INTO crrencyrate VALUES("77","2","5","1","11000.000","1397-12-01","16:28:00","1");
INSERT INTO crrencyrate VALUES("78","2","4","1","138.000","1397-12-01","16:28:15","1");
INSERT INTO crrencyrate VALUES("79","2","3","1","1.145","1397-12-01","16:28:31","1");
INSERT INTO crrencyrate VALUES("80","2","1","1","75.500","1397-12-05","16:32:14","1");
INSERT INTO crrencyrate VALUES("81","3","2","1","1.145","1397-12-05","16:32:27","1");
INSERT INTO crrencyrate VALUES("82","2","4","1","140.000","1397-12-05","16:32:40","1");
INSERT INTO crrencyrate VALUES("83","2","5","1","11800.000","1397-12-05","16:32:51","1");



DROP TABLE IF EXISTS currencies;

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO currencies VALUES("1","افغانی ","0");
INSERT INTO currencies VALUES("2","دالر","0");
INSERT INTO currencies VALUES("3","یورو","0");
INSERT INTO currencies VALUES("4","کلدار ","0");
INSERT INTO currencies VALUES("5","تومان","0");
INSERT INTO currencies VALUES("6","پوند","0");



DROP TABLE IF EXISTS currencieslist;

CREATE TABLE `currencieslist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `countery` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;




DROP TABLE IF EXISTS customer_statement;

CREATE TABLE `customer_statement` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(30) COLLATE utf8mb4_persian_ci NOT NULL,
  `transaction_id` int(11) NOT NULL,
  `customerId` int(11) NOT NULL,
  `currency_id` int(11) NOT NULL,
  `amount` decimal(17,4) NOT NULL,
  `date` varchar(30) COLLATE utf8mb4_persian_ci NOT NULL,
  `transaction_type` int(11) NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_persian_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

INSERT INTO customer_statement VALUES("1","معاملات مشتری","1","324","1","200000.0000","1397-12-07","1","");
INSERT INTO customer_statement VALUES("2","معاملات مشتری","2","278","1","200000.0000","1397-12-07","2","");
INSERT INTO customer_statement VALUES("3","معاملات مشتری","3","324","1","300000.0000","1397-12-08","1","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO customer_statement VALUES("4","معاملات مشتری","4","278","1","300000.0000","1397-12-08","2","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO customer_statement VALUES("5","معاملات مشتری","5","324","1","300000.0000","1397-12-08","1","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO customer_statement VALUES("6","معاملات مشتری","6","278","1","300000.0000","1397-12-08","2","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO customer_statement VALUES("7","معاملات مشتری","7","324","1","300000.0000","1397-12-08","1","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO customer_statement VALUES("8","معاملات مشتری","8","278","1","300000.0000","1397-12-08","2","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO customer_statement VALUES("9","معاملات مشتری","9","325","1","20000.0000","1397-12-08","1","");
INSERT INTO customer_statement VALUES("10","معاملات مشتری","10","278","1","20000.0000","1397-12-08","2","");



DROP TABLE IF EXISTS customerbalance;

CREATE TABLE `customerbalance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(30) COLLATE utf8_persian_ci NOT NULL,
  `customerId` int(11) NOT NULL,
  `currencyId` int(11) NOT NULL,
  `amount` decimal(17,4) NOT NULL,
  `dollarAmount` decimal(17,4) NOT NULL,
  `openingBalance` decimal(17,6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;

INSERT INTO customerbalance VALUES("1","1397-12-07","324","1","1100000.0000","0.0000","0.000000");
INSERT INTO customerbalance VALUES("2","1397-12-07","278","1","-920000.0000","0.0000","0.000000");
INSERT INTO customerbalance VALUES("3","1397-12-08","325","1","20000.0000","0.0000","0.000000");



DROP TABLE IF EXISTS customeropeningbalance;

CREATE TABLE `customeropeningbalance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(30) COLLATE utf8_persian_ci NOT NULL,
  `customerId` int(11) NOT NULL,
  `currencyId` int(11) NOT NULL,
  `amount` decimal(17,6) NOT NULL,
  `rate` decimal(17,6) NOT NULL,
  `dollarAmount` decimal(17,6) NOT NULL,
  `description` text COLLATE utf8_persian_ci NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;




DROP TABLE IF EXISTS customerpayment;

CREATE TABLE `customerpayment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customersell_id` int(11) NOT NULL,
  `customerId` int(11) NOT NULL,
  `date` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `referenceNo` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `transacttype` int(11) NOT NULL,
  `transactCurrency` int(11) NOT NULL,
  `customerasset` decimal(17,4) NOT NULL,
  `amount` decimal(17,4) NOT NULL,
  `customerRemain` decimal(17,4) NOT NULL,
  `dollarRate` decimal(17,6) NOT NULL,
  `dollarTotal` decimal(17,4) NOT NULL,
  `description` text COLLATE utf8_persian_ci NOT NULL,
  `bank_id` int(11) NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;

INSERT INTO customerpayment VALUES("1","0","324","1397-12-07","","1","1","0.0000","200000.0000","0.0000","0.000000","0.0000","","0","0");
INSERT INTO customerpayment VALUES("2","0","278","1397-12-07","","2","1","0.0000","200000.0000","0.0000","0.000000","0.0000","","0","0");
INSERT INTO customerpayment VALUES("3","0","324","1397-12-08","","1","1","0.0000","300000.0000","0.0000","0.000000","0.0000","نقل از این حساب به به حساب اقای نعمت","0","0");
INSERT INTO customerpayment VALUES("4","0","278","1397-12-08","","2","1","0.0000","300000.0000","0.0000","0.000000","0.0000","نقل از این حساب به به حساب اقای نعمت","0","0");
INSERT INTO customerpayment VALUES("5","0","324","1397-12-08","","1","1","0.0000","300000.0000","0.0000","0.000000","0.0000","نقل از این حساب به به حساب اقای نعمت","0","0");
INSERT INTO customerpayment VALUES("6","0","278","1397-12-08","","2","1","0.0000","300000.0000","0.0000","0.000000","0.0000","نقل از این حساب به به حساب اقای نعمت","0","0");
INSERT INTO customerpayment VALUES("7","0","324","1397-12-08","","1","1","0.0000","300000.0000","0.0000","0.000000","0.0000","نقل از این حساب به به حساب اقای نعمت","0","0");
INSERT INTO customerpayment VALUES("8","0","278","1397-12-08","","2","1","0.0000","300000.0000","0.0000","0.000000","0.0000","نقل از این حساب به به حساب اقای نعمت","0","0");
INSERT INTO customerpayment VALUES("9","0","325","1397-12-08","","1","1","0.0000","20000.0000","0.0000","0.000000","0.0000","","0","0");
INSERT INTO customerpayment VALUES("10","0","278","1397-12-08","","2","1","0.0000","20000.0000","0.0000","0.000000","0.0000","","0","0");



DROP TABLE IF EXISTS customers;

CREATE TABLE `customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `fname` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `phone` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `address` text COLLATE utf8_persian_ci NOT NULL,
  `description` text COLLATE utf8_persian_ci NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=326 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;

INSERT INTO customers VALUES("1","طلبات جکنه ","0","07","خ","نقل از گمپیوتر آق صلحب","1");
INSERT INTO customers VALUES("3","حاجی گل احمد حاجی زاده ","74","0799251925","خراسان مارکت ","نقل شد","0");
INSERT INTO customers VALUES("8","فرهاد قلعه نوی ","111111","0799","خراسان مارکت ","همسایه","1");
INSERT INTO customers VALUES("9","طارق موتر فروش","333","0700","موتر فروش","موتر فروش ","1");
INSERT INTO customers VALUES("10","لست قرضداری ","55555","2225872","نامعلوم ","خدا گرفت","1");
INSERT INTO customers VALUES("11","لست قرضداری ","10","10","نامعلوم ","حدا گرفت ","0");
INSERT INTO customers VALUES("12","لست طلبات ","11","11","نامعوم ","معلوم نیست","0");
INSERT INTO customers VALUES("14","طارق موتر فروش","44","0799","موتر فروشی ها ","موتر فروش هست","0");
INSERT INTO customers VALUES("15","فرهاد قلعه نوی ","39","0786499373","خراسات مارکت 70","همسایه","0");
INSERT INTO customers VALUES("16","فرید احمد عادلی","1","0700401525","رازی مادکت ","صراف بین بارار ","0");
INSERT INTO customers VALUES("18","عبدالرحیم و عبدالغفور ","100","070022","دوگاندار","دوست حاجی عثمان بزاز","0");
INSERT INTO customers VALUES("19","غلام حضرت بختیار ","101","0700222","نامعلوم","بختیار","0");
INSERT INTO customers VALUES("21","آقا محمد دین جامی ","20000","07999999","نامعلوم ","دوست آقا صاحب ","0");
INSERT INTO customers VALUES("22","محمد رفیق فیض ","99999999","799999","چهارای امریت ","فیص ","0");
INSERT INTO customers VALUES("23","عبدالحمید باغدشتی ","111111111","8888888","باغدشت","پرزه دارد ","0");
INSERT INTO customers VALUES("24","احمد شاه شادان کمرک","3333333","9999999999","نامعلوم ","","0");
INSERT INTO customers VALUES("25","فرهاد حبیبی ","9","99","موتر فروش ","موتر فروش","0");
INSERT INTO customers VALUES("27","خلیل احمد احمدی ","1919","1999","نامعلوم ","ناشناس","0");
INSERT INTO customers VALUES("28","زلمی ","88","0899","نامعلوم","ناشناس","0");
INSERT INTO customers VALUES("29","مستری خداداد","1675","08000000","باغدشت ","بچه خاله","0");
INSERT INTO customers VALUES("30","تمیم حبیبی ","9000","079956","موتر فروش","برادر فرهاد ","0");
INSERT INTO customers VALUES("31","ملوک صدیقی ","49","004999","المان","قوم حاجی جلیل اکبری ","0");
INSERT INTO customers VALUES("32","ایران حساب ملت سعید امیری ","98","00985","ایران ","بانگ ملت ایران ","0");
INSERT INTO customers VALUES("33","حاجی عصمت الله حسینی ","10000","07888888","نامعلوم ","حسینی 
","0");
INSERT INTO customers VALUES("34","احسان صراف","7000","70000","نامعلوم","خراسان مارکت ","0");
INSERT INTO customers VALUES("35","حساب عزیزی بانک ","9900","0900","کابل","حساب حدید ","0");
INSERT INTO customers VALUES("36","یاسر منصوری ","9000000","9898","موتر فروش","ننکیالی منصوری ","0");
INSERT INTO customers VALUES("37","حاجی مجید سلیمانی ","3939","0098815","صادق 33","همسایه ","0");
INSERT INTO customers VALUES("38","عزیز محمودی ","491212","004922222","المان","احواله المان ","0");
INSERT INTO customers VALUES("39","عزیز محمودی حساب کمیشن ها","89898989","0049999999","المان 2","مفاد عزیز محمودی ","0");
INSERT INTO customers VALUES("40","وکیل احمد حیدری ","2147483647","0799000000","نامعلوم","حیدری ","0");
INSERT INTO customers VALUES("41","ننگیالی منصوری ","12345","0788261000","موتر فروش","منصوری ","0");
INSERT INTO customers VALUES("43","فضل احمد فیروز ","77777","07990","نامعلوم ","ماما سید ظار","0");
INSERT INTO customers VALUES("44","غلام رسول پرزه دارد","200000","089900","نامعلوم ","نامعلوم","0");
INSERT INTO customers VALUES("45","محمد داوود افضل","6666","666666","نامعلوم ","دوست حاجی غلام احمدجان  امیری ","0");
INSERT INTO customers VALUES("46","خلیل احمد واعظی ","1711","0799001711","جاده بانگ خون ","بچه خاله ","0");
INSERT INTO customers VALUES("47","حمید الله رحیمی ","909090","090909","نامعلوم ","رحیمی ","0");
INSERT INTO customers VALUES("48","بانگ صادرات حساب سعید امیری ","2","0785100002","ایران","امیری ","0");
INSERT INTO customers VALUES("49","قاسم اوبهی ","90","08908","پرزه فر.شی ها ","اوبهی","0");
INSERT INTO customers VALUES("50","سید خلیل فاروقی ","799360","0799360207","هالند ","حسوربوره ظاهر جان ","0");
INSERT INTO customers VALUES("51","انجینر نصرالله ","1010","0101010","باغدشت ","پرزه فروش ","0");
INSERT INTO customers VALUES("52","یاسین حیدریار ","360","0799360207","ظاهر جان ","مربوط ظاهر جان ","0");
INSERT INTO customers VALUES("53","عبدالولی موتر فروش ","5454","545454","موتر فروشی ها ","برادر توریالی ","0");
INSERT INTO customers VALUES("54","حساب دوکان کابل","169","0202104597","کابل دوکان 169","مربوط امیری ها","0");
INSERT INTO customers VALUES("55","حساب عبدالاحمد امیری ","246060","0789100000","سرای شهزاده","مریوط امیری ها ","0");
INSERT INTO customers VALUES("56","فضل احمد دوبی ","97","0097150","دوبی ","فضل احمد شندند ","0");
INSERT INTO customers VALUES("57","محمد شفیع بهبودی ","6699","09876","نامعلوم ","نامعلوم ","0");
INSERT INTO customers VALUES("58","توریالی موتر فروش ","987655","09090990","موتر فروش ","برادر عبدالولی ","0");
INSERT INTO customers VALUES("60","علی احمد محمدی","1122","0799240","نامعاوم ","نامعاوم ","0");
INSERT INTO customers VALUES("61","بصیر احمد رحیمی احواله مولوی زاده","39393939","0937937","نامعاوم","خدا گرفت","0");
INSERT INTO customers VALUES("62","شرکت احسان فارما ","565656","6565","دوا فروشی ها ","داکتر جواد ","0");
INSERT INTO customers VALUES("63","ظاهز درویشی ","67890","09876544","درب کندهار","ظاهر درویشی","0");
INSERT INTO customers VALUES("64","تواب اکبری ","334455","87678","نامعلوم","خسوربوره حاجی جلیل اکبری ","0");
INSERT INTO customers VALUES("65","محمد نعیم اکبری ","98789","98989","نامعلوم ","قوم حاجی جلیل اگبری ","0");
INSERT INTO customers VALUES("66","غلام نبی طلا ","88990","009090","کلینیک ","برادر غلام سخی ","0");
INSERT INTO customers VALUES("67","صرافی نوی عزیزی ","200","08978789","خراسان مارکت ","ضیا دوست","0");
INSERT INTO customers VALUES("68","خلیل احند هروی ","454545","0039","هالند","خلیل هالند ","0");
INSERT INTO customers VALUES("69","حاجی حمیدالله حسینی ","559999","997788","نامعلوم ","برادر حاجی عصمت الله حسینی ","0");
INSERT INTO customers VALUES("70","حاجی نیک محمد باغدشت","6789000","009998766","باغدشت ","حاجی نیک ","0");
INSERT INTO customers VALUES("71","عبدالمک علاف قربانی ","8765443","4567887","مندی فرایا","علاف ها","0");
INSERT INTO customers VALUES("72","عبدالحکیم احواله نو آفرین ","67676","776677898","نامعلوم ","از متباقی احواله نو آفرین ","0");
INSERT INTO customers VALUES("73","محمد صادق باغدشتی ","565432","1234321","باغدشت","احواله صرافی دارد ","0");
INSERT INTO customers VALUES("74","قاری نور شاه یلانی ","67343256","065643","ایران ","قاری نورشاه ","0");
INSERT INTO customers VALUES("75","حمید الله سلطانی ","8767676","89898678","نامعلوم ","دوست عبدالرحیم و عبدالففور ","0");
INSERT INTO customers VALUES("76","شرکت هرات تراویل ","7987","89656","شهرنو","سید ظاهر سید تواب ","0");
INSERT INTO customers VALUES("77","محمد یونس پسر غلام سرورمیدان بار","54545454","7675757","درب خوش ","بچه غلام سرور میدان بار","0");
INSERT INTO customers VALUES("78","فواد رستکار ","67654","434567","شهرنو ","برادر فریدون ","0");
INSERT INTO customers VALUES("79","شرکت افغان ترکمن ","8190","0193","حسیب ابراهیم خیل ","حسب ابراهیم خیل","0");
INSERT INTO customers VALUES("80","شرکت عارف معروف ","93567","837568","باغدشت","حمیدالله عثمانی ","0");
INSERT INTO customers VALUES("81","سید وحید حسینی ","70989","92578","نامعلوم ","بردر قاری نورشاه ","0");
INSERT INTO customers VALUES("82","ضیا امینی ","13687","294665","نامعلوم ","ماما طارق موتر فروش","0");
INSERT INTO customers VALUES("83","عبدالمنان یوسفی ","4876540","1093658","باغدشت","بچه عبدالرحمن یوسفی ","0");
INSERT INTO customers VALUES("84","داکتر سلطان احمد یارزاده","1358765","10395673","دوا فروشی ها ","شزکت تبن سینا ","0");
INSERT INTO customers VALUES("85","وحید مهمند برادر زلمی مهمند ","592098","103679","نامعلوم ","بردر زلمی مهمند ","0");
INSERT INTO customers VALUES("86","عبدالرحمن صادقی ","710874","5987650","نامعلوم","نامعلوم ","0");
INSERT INTO customers VALUES("87","غلام حضرت ","5673940","204294875","نامعلوم ","پرزه دارد","0");
INSERT INTO customers VALUES("88","قاری محمد رفیق غفوری ","34573948","3275834","خراسان مارکت","برادر حاجی وکیل احمد غفوری ","0");
INSERT INTO customers VALUES("89","عبدالسمیع شرزاد ","5473984","3850934875","نامعلوم ","نامعلوم هست","0");
INSERT INTO customers VALUES("90","فیروز صدیقی ","47639867","3573984367","تیل فروشی ها","برادر وحید صدیقی ","0");
INSERT INTO customers VALUES("91","عبدالرازق عظیمی ","587689","34769834","نامعلوم ","دوست عبدالقادر بختیار ","0");
INSERT INTO customers VALUES("92","محمد نعیم صدیقی ","5876983","4042596590","المان","دوست ظاهر جان حیدریار ","0");
INSERT INTO customers VALUES("93","حاجی جلیل اکبری ","5673867","23745834","نامعلوم ","اکبری ","0");
INSERT INTO customers VALUES("94","سید یحیحی باغدشتی ","3487938","384753","باغدشت ","بچه آقا صاحب","0");
INSERT INTO customers VALUES("95","احسان صدیقی بچه ماما","48693","34875389","باغدشت","بچه ماما ","0");
INSERT INTO customers VALUES("96","حاجی حسین خان ","83573498","3467489","نامعلوم ","نمیشناسم","0");
INSERT INTO customers VALUES("97","حاجی همایون مولوی زاده","45873","35876387","هالند ","همایون مولوی زاده","0");
INSERT INTO customers VALUES("98","عبدالرحمن پرزه فروش ","356387","346738","پرزه فر.شی ها ","بردز حاجی انجینر نصرالله","0");
INSERT INTO customers VALUES("99","محمد داوود احراری ","56348","929347853","نامعلوم ","نامعلوم ","0");
INSERT INTO customers VALUES("100","نور محمد پرزه دارد","456798324","34687","نامعلوم ","نامعلوم ","0");
INSERT INTO customers VALUES("101","حاجی غلام یحیحی ماما حاجی نعمان","58376349","34875639","باغدشت ","صدیقی ","0");
INSERT INTO customers VALUES("102","سید عظیم حسینی ","48637934","34867923","ایران","","0");
INSERT INTO customers VALUES("103","صوفی نصیر احمد یارزاده","348769","457398","جادخه بهزاد","","0");
INSERT INTO customers VALUES("104","شرکت سهیل یارزاده","436893","93485409","جاده بهزاد","صوفی نصیر احمد یارزاده","0");
INSERT INTO customers VALUES("105","مدیر صاحب مستوفیت ","45986","349803","مستوفیت","دوست انور جان حیدریار ","0");
INSERT INTO customers VALUES("106","کرایه جات امیری ","3486398","3487953","خراسان مارکت ","مربوط امیری ها","0");
INSERT INTO customers VALUES("107","انجینر توخی ","438679","3486798","المان","ویس توخی ","0");
INSERT INTO customers VALUES("108","فیض احمد باغدشتی ","34876349","4398793","باغدشت","بچه عزیز احمد نوری ","0");
INSERT INTO customers VALUES("109","حبیب الرحمن تیل فروش","4387","3487693","تیل فروش ها","","0");
INSERT INTO customers VALUES("110","حاجی شجاع الدین احمدی ","438769","32498539","المان","","0");
INSERT INTO customers VALUES("111","ناصر حیدری ","348759","235932","نامعلوم ","نامعلوم","0");
INSERT INTO customers VALUES("112","حاجی قادر جان ماما صدیقی","384789","8ص4953","باغدشت","","0");
INSERT INTO customers VALUES("113","حاجی فادر شاه باغدشتی ","30498503","384975","باغدشت ","بچه ماما ظاهر","0");
INSERT INTO customers VALUES("114","والده زلمی پرزه دارد ","123950","95102345","نامعلوم","","0");
INSERT INTO customers VALUES("115","حاجی بهبود صراف قلعهنوی ","3405830","934850132","خراسان مارکت ","","0");
INSERT INTO customers VALUES("116","قاسم ولی زاده ازدرک احواله علاف ها","932487590","4592","درب خوش ","","0");
INSERT INTO customers VALUES("117","شاه محمد کام ایر ","239058032","380409","نامعلوم ","","0");
INSERT INTO customers VALUES("118","شیخ حبیب ","30945","30945980","نامعلوم","","0");
INSERT INTO customers VALUES("119","شرکت رامین یونس ","34986903","54302","باغدشت ","غلام سرور میدان بار","0");
INSERT INTO customers VALUES("120","حاجی ابوبکر جان ماما","3947593","0400401613","باغدشت ","","0");
INSERT INTO customers VALUES("121","حمیدالله بچه ماما ظاهر جان","876934","349895372","نامعلوم ","","0");
INSERT INTO customers VALUES("122","محمد امین کریمی ","458304","345803","نامعلوم ","","0");
INSERT INTO customers VALUES("124","محمد باغدشت","834579","3459934","باغدشت","","0");
INSERT INTO customers VALUES("125","فرهاد باغدشت","349895","3498590","باغدشت","بچه قاضی رسول","0");
INSERT INTO customers VALUES("126","شرکت مشرب ","4398352","435800","مزار ","مربوط علاف ها","0");
INSERT INTO customers VALUES("127","غلام سرور رحمانی ","239857","32593","نامعلوم","","0");
INSERT INTO customers VALUES("128","عتیق الله رحمانی ","39487","09435032","دوست عصمت الله","","0");
INSERT INTO customers VALUES("129","نبی الله","23098","20934","نامعلوم","","0");
INSERT INTO customers VALUES("130","نعمت الله احواله ولی زاده","32984","2039840","نامعلوم ","","0");
INSERT INTO customers VALUES("131","انجینر حامد و صوفی فهیم","203598","203958","ترکیه","","0");
INSERT INTO customers VALUES("132","سیدعبدالرحیم آقا","2938754","9039222","نامعلوم ","","0");
INSERT INTO customers VALUES("133","حاجی جلیل صراف حاجی ذین ادین","3894","28934","رازی مارکت","","0");
INSERT INTO customers VALUES("134","سید ظاهر نعیمی ایران ","9430125","293109","شهرنو","","0");
INSERT INTO customers VALUES("135","خواجه غلام دستگیر ","20395","20351","نامعلوم ","قوم ها معین الدین","0");
INSERT INTO customers VALUES("136","کد 3355 امیری مربوط منان ترانسپورت","2019350","20193580","درب خوش ","میرزا عبدالرزاق","0");
INSERT INTO customers VALUES("137","عبداجبار پرزه دارد","230950","203950","نامعلوم ","","0");
INSERT INTO customers VALUES("138","حاجی داوود نوری ","20394092","10239482","باغدشت ","بچه خاله","0");
INSERT INTO customers VALUES("139","رفیق احمد فقیریار ","92834519","234292","المان","ماما حاجی نعمان","0");
INSERT INTO customers VALUES("140","حاجی محمد عمر یوسفی","389291","303923","نامعلوم ","","0");
INSERT INTO customers VALUES("141","عبدالطیف صدیقی","309450","13050345","نامعلوم ","","0");
INSERT INTO customers VALUES("142","سعید جان نورزاده ","20935802","32023","کابل","","0");
INSERT INTO customers VALUES("143","حاجی علی احمد غفوری ","203482","2093502","نامعلوم ","","0");
INSERT INTO customers VALUES("145","شعیب حیدری","2093840","23098402","المان","","0");
INSERT INTO customers VALUES("146","کد 61 امیری ","23948720","123980","ایران","","0");
INSERT INTO customers VALUES("147","حاجی حسیب امیری حساب شخصی و ایران","2309","023945890","ترکیه","","0");
INSERT INTO customers VALUES("148","میرویس سعیدی ","39280213","20390","ملی سنتر ","","0");
INSERT INTO customers VALUES("149","شیخ اکبر شاه ","29034","203108","نامعلوم ","","0");
INSERT INTO customers VALUES("150","حمیدالله مشتاق","23201","023902","نامعلوم ","","0");
INSERT INTO customers VALUES("151","خالد عظیم","2039840","230023","المان","","0");
INSERT INTO customers VALUES("152","ندیم حبیبی ","2938402","2340238","موتر فروش","برادر فرهاد","0");
INSERT INTO customers VALUES("153","انجینرضیا عفوری","289351923","23985702","نامعلوم","","0");
INSERT INTO customers VALUES("154","وحید یلانی ","230290","2340233","نامعلوم","","0");
INSERT INTO customers VALUES("155","حاجی عبدالرحیم صدیقی صراف","231502","45627309","خراسان مارکت ","","0");
INSERT INTO customers VALUES("156","غلام سرور کبابی ","2385901","92347850","باغدشت","","0");
INSERT INTO customers VALUES("157","خیر محمد نیاری ","23957","238523","نامعلوم","","0");
INSERT INTO customers VALUES("158","حاجی بهاادین صراف ریس","475139","238579","خراسان مادکت","","0");
INSERT INTO customers VALUES("159","احمد سیر قوم سید ظاهر","203485","3467329","نامعلوم ","","0");
INSERT INTO customers VALUES("160","کد 841 امیری ","57219375","2305980","نامعلوم","","0");
INSERT INTO customers VALUES("161","محمد اسحاق اکبری برادرزاده جلیل اکبری ","48103","851032","نامعلوم","","0");
INSERT INTO customers VALUES("162","وحید حیدری ","30498650","34698013","نامعلوم ","","0");
INSERT INTO customers VALUES("163","دانیال بختیار ","2093802","2098501","نامعلوم ","","0");
INSERT INTO customers VALUES("164","عبدالقدیر صدیقی ","235980","29358","نامعلوم ","","0");
INSERT INTO customers VALUES("165","حاجی حسیب ابراهیم خیل حساب شخصی ","23093","325102","نامعلوم ","","0");
INSERT INTO customers VALUES("166","محمد قاسم نوری ","203958","319671","باغدشت","","0");
INSERT INTO customers VALUES("167","غلام سرور محمدی شندند","3857","2985792","نامعلوم ","","0");
INSERT INTO customers VALUES("168","حاجی سید ظاهر اریانا ","823579","0799372222","شهرنو","","0");
INSERT INTO customers VALUES("169","حاجی غلام خلیل صدیقی ","352879","483793","نامعلوم ","","0");
INSERT INTO customers VALUES("170","حصین 1794","1794","238794","نامعلوم ","بصیراحمد کمرک","0");
INSERT INTO customers VALUES("171","احسان ضیایی موبایل فروش","298375","239580","نامعلوم ","","0");
INSERT INTO customers VALUES("172","سیف اطاق بالا","2389502","358712","خراسان مارکت ","","0");
INSERT INTO customers VALUES("173","حاجی عبدالرحیم نوری ","9325801","9538012","باغدشت","","0");
INSERT INTO customers VALUES("174","حساب میوند بانگ حساب شخصی حاجی غلام محمد","329875","2935870","نامعلوم ","","0");
INSERT INTO customers VALUES("175","حاجی غلام رسول علاف قربانی","893257","23500","مندی فرایا","","0");
INSERT INTO customers VALUES("176","غلام صدیق شمس ","231759","2035902","نامعاوم","داماد استاد بصیر ","0");
INSERT INTO customers VALUES("177","شرکت عثمان خالد و شرکت خان","23875912","93875192","نامعلوم ","","0");
INSERT INTO customers VALUES("178","حاجی میرنادر صراف ","20395810","4398103","خراسان مارکت ","","0");
INSERT INTO customers VALUES("179","حاجی غلام جیلانی علاف ","29387534","2935801","مندی فرایا","","0");
INSERT INTO customers VALUES("180","حاجی محمد هاشم پرزه دارد","3941809","38467193","نامعاوم","","0");
INSERT INTO customers VALUES("181","حاجی حمیدالله صدیقی صراف","84237519","3487535","خراسان مارکت ","","0");
INSERT INTO customers VALUES("182","غلام سخی زاره ","142","34871596","نامعلوم","","0");
INSERT INTO customers VALUES("183","وحید توخی ","857934","3257891","نامعلوم ","","0");
INSERT INTO customers VALUES("184","وحید علاف عزیزی علاف","438719","29358791","جکان","","0");
INSERT INTO customers VALUES("185","کد 12 امیری ","923457","2324751","نامعاوم","","0");
INSERT INTO customers VALUES("186","خلیل احمد این سینا","92385739","8923759","دوا فروشی ها ","","0");
INSERT INTO customers VALUES("187","بصیر احمد برهانی","2387519","2389023","المان","","0");
INSERT INTO customers VALUES("188","بسم الله ازدرک احواله 9","93487129","235870213","نامعلوم","","0");
INSERT INTO customers VALUES("189","صوفی نثار احمد باغدشتی ","20935810","290384","باغدشت","","0");
INSERT INTO customers VALUES("190","عبدالقادر بختیار ","23859329","33290221","نامعلوم ","","0");
INSERT INTO customers VALUES("191","نزیر احمد  باغدشت","903248120","2039482","باغدشت","بچه کبیر خان ","0");
INSERT INTO customers VALUES("192","نجیب الله صمد یار ","3982751","9302180","نامعلوم ","","0");
INSERT INTO customers VALUES("193","وزیر احمد جمشیدی ","29387491","2093850","موتر فروشی ها ","","0");
INSERT INTO customers VALUES("194","بانگ اسلامی حساب حدید","23908510","20935802","خراسان مارکت ","","0");
INSERT INTO customers VALUES("195","غلام سرور میدان بار عارف معروف","2938751","219385792","درب خوش ","","0");
INSERT INTO customers VALUES("196","شرکت ابراهیم ایوب ","2390480","03249850","جاده بانک ح.ن مارکت تکه فروش ها","حاجی عثمان بزاز ","0");
INSERT INTO customers VALUES("197","فریدون رستگار ","9283759","0329581","ایران ","","0");
INSERT INTO customers VALUES("198","حساب صادرات فریدون رستگار ","2389749","239891","بانگ صادرات ایران","","0");
INSERT INTO customers VALUES("199","مصارف اطاق دوکان صرافی ","238759812","823457921","خراسان مارکت ","","0");
INSERT INTO customers VALUES("200","معین الدین جامی ","2039580","0703818283","نامعلوم ","","0");
INSERT INTO customers VALUES("201","خدمات پولی AIB بانگ","4387119","235810","جاده بهزاد","","0");
INSERT INTO customers VALUES("202","سید عبدالحکیم آقا","32189759","20394802","نامعلوم ","خسور حاجی عبدالاله","0");
INSERT INTO customers VALUES("203","محمد عارف شندند حلمی ","8235719","29358013","موتر فروشی ها ","","0");
INSERT INTO customers VALUES("204","حمید ارسلان دوست حاجی عبدالاله","198327509","13840÷2","امریکاه","","0");
INSERT INTO customers VALUES("205","حساب ایران حاجی غلام احمد امیری ","23948902","329840÷2","بانگ صادرات ایران","","0");
INSERT INTO customers VALUES("206","خالد جباری ","932801","209348102","تیل فروشی ها","","0");
INSERT INTO customers VALUES("207","یوناتید بانگ بعداز موجودی ","1393","83951290","خراسان مارکت ","","0");
INSERT INTO customers VALUES("208","حساب ایران بانگ ملت","23094802","230498","ایران","","0");
INSERT INTO customers VALUES("209","زکات مربوط امیری ها","32874902","235802","خراسان مارکت ","","0");
INSERT INTO customers VALUES("210","روح الامین امیری ","2398501","29384102","خراسان مارکت ","","0");
INSERT INTO customers VALUES("211","کد 4544 به حساب امیری","239879","3275923","نامعلوم","","0");
INSERT INTO customers VALUES("212","سید علی حسینی","349503","501900123","نامعلوم ","مربوط وحید حیدری تالار","0");
INSERT INTO customers VALUES("213","عبدالله یمایی ","3275192","9325801","پوهنتون آسیا","","0");
INSERT INTO customers VALUES("214","نزیر احمد قاسمیان","23879","38257921","جاده بهزاد","","0");
INSERT INTO customers VALUES("215","حاجی فرشید صدیقی بچه ماما","235710","20398501","باغدشت","","0");
INSERT INTO customers VALUES("216","حاجی وکیل احمد نوری ","23987519","293850","باغدشت","","0");
INSERT INTO customers VALUES("217","جلیل اوغان صراف ","324796","2938401","خراسان مارکت ","","0");
INSERT INTO customers VALUES("218","اختر محمد توخی ","823759","231479","المان","","0");
INSERT INTO customers VALUES("219","استاد بصیر هرات چینا ","2895739","2918357","هرات چینا ","","0");
INSERT INTO customers VALUES("220","احمد شفیق هری ","289453719","2938571","نامعلوم","","0");
INSERT INTO customers VALUES("221","قادر صدیقی صراف ","2189357","923875","نامعلوم ","","0");
INSERT INTO customers VALUES("222","مصطفی روفی ","9238750","2390480","موتر فروشی ها ","","0");
INSERT INTO customers VALUES("223","حاجی نصرالله وکیل ","23749","23840","نامعلوم","","0");
INSERT INTO customers VALUES("224","حاجی محمد اریانا","23875913","28937492","نامعلوم ","دوست سید ظاهر ","0");
INSERT INTO customers VALUES("225","احمد باغدشتی پرزه دارد ","2930840","213840","نامعلوم ","","0");
INSERT INTO customers VALUES("226","نصیر احمد افضل ","29387591","98123759","نامعاوم","","0");
INSERT INTO customers VALUES("227","حساب توفیق صدیقی بانگ صادرات ایران","923187419","92834971","ایران","","0");
INSERT INTO customers VALUES("228","فیض احمد شیخ زاده ","2398479","29348729","نامعاوم","","0");
INSERT INTO customers VALUES("229","شرکت هرات فارما","93248752","298135792","دوا فروشی ها ","","0");
INSERT INTO customers VALUES("230","حاجی غلام حسن صراف","9832457","29387490","خراسان مارکت ","","0");
INSERT INTO customers VALUES("231","بصیر احمد باشی زاده","932817","239854910","باغدشت","","0");
INSERT INTO customers VALUES("232","برادران امیری ","2389741","20934801","خراسان مارکت ","","0");
INSERT INTO customers VALUES("233","حاجی غلام احمد امیری مصارف خانه","298374","239057","باغدشت ","","0");
INSERT INTO customers VALUES("234","شرکت هرات چینا امیری ","9832475","09328510","سرک 64 متره","","0");
INSERT INTO customers VALUES("235","حاجی همایون شریفی صراف ","92837594","4387951","کابل","صرافی هرات","0");
INSERT INTO customers VALUES("236","شعیب حیدریار ظاهر جان","41389759","02395801","نامعلوم","","0");
INSERT INTO customers VALUES("237","حاجی عبدالجلیل باغدشتی","923847519","129385379","باغدشت ","","0");
INSERT INTO customers VALUES("238","جمشید عثمانی باغدشتی ","2389579","192387","باغدشتی ","","0");
INSERT INTO customers VALUES("239","میوند بانک حساب جدید خدمات پولی حاجی غلام احم","2893479","20934823","خراسان مارکت ","","0");
INSERT INTO customers VALUES("240","عبدالصمد سینانی","154","29837591","نامعلوم","","0");
INSERT INTO customers VALUES("241","حاجی عبدالوهاب اکبری ","329481579","2093587012","نامعلوم ","","0");
INSERT INTO customers VALUES("242","ناصر عرب زاده باغدشتی ","6739467","4368719","باغدشت ","","0");
INSERT INTO customers VALUES("243","حاجی عبدالفتاح اکبری ","34710","3245710","نامعلوم ","","0");
INSERT INTO customers VALUES("244","عزیز مستری ","4687913","4687193","نامعلوم ","","0");
INSERT INTO customers VALUES("245","محراب قلعه نوی حاجی بهبود","43687139","34699013","خراسان مارکت ","","0");
INSERT INTO customers VALUES("246","بصیر احمد قاسمیان","49610","09568012","جاده بهزاد","","0");
INSERT INTO customers VALUES("247","محمد نافع ازدرک احواله غلام سرور","384619","25322","نامعلوم ","","0");
INSERT INTO customers VALUES("248","نادر رسولی ","34853","23958203","نامعلوم","","0");
INSERT INTO customers VALUES("249","خواجه محمد صادق انصاریان","45340513","23598290","درب خوش ","شرکت انصاریان","0");
INSERT INTO customers VALUES("250","صرافی هرات توانا","932050","2358702","رازی مادکت ","عبدالواحد ","0");
INSERT INTO customers VALUES("251","سید تواب نعمی ","235987910","23875901","شهرنو","","0");
INSERT INTO customers VALUES("252","حسیب قومی ","94015","320915","باغدشتی ","برادر زاده انجینر نصرالله","0");
INSERT INTO customers VALUES("253","حاجی وکیل احمد صراف غفوری ","2357012","25702","خراسان مارکت ","","0");
INSERT INTO customers VALUES("254","بسم الله صدیقی بچه ماما","29357810","0799642266","باغدشت","","0");
INSERT INTO customers VALUES("255","عبدالجبار صراف ","2398570","4390241","خراسان مارکت ","","0");
INSERT INTO customers VALUES("256","فواد صراف یورو ","2945180","20395021","خراسان مارکت ","","0");
INSERT INTO customers VALUES("257","حاجی بریالی غوثی ","9328401","ه210395","خراسان مارکت ","","0");
INSERT INTO customers VALUES("258","وحید هرات چینا ","23095810","÷2903840","سرک 64 متره","","0");
INSERT INTO customers VALUES("259","مولوی عبدالقدوس ","23948021","92358023","صادق 33","خدا گرفت","0");
INSERT INTO customers VALUES("260","حاجی وحید حبیبی صراف ","2358701","23577","خراسان مارکت ","","0");
INSERT INTO customers VALUES("261","عبدالرحمن سینانی و اسد ","471539","385719382","خراسان مارکت ","","0");
INSERT INTO customers VALUES("262","شهاب حبیبی ","346139","36519735","موتر فروشی ها ","","0");
INSERT INTO customers VALUES("263","انجینر احمد فرید ","43819","45793485","نامعلوم ","","0");
INSERT INTO customers VALUES("264","فرهاد صدیقی ","365913092","486731946","نامعلوم","","0");
INSERT INTO customers VALUES("265","فردین رستگار ","56013297","571976309","نامعاوم","","0");
INSERT INTO customers VALUES("266","عبدالحکیم عزیزی ","467913","285719","نامعلوم ","","0");
INSERT INTO customers VALUES("267","بصیر احمد رحمانی دوست حاجی عبدالاله","3671394","34561","نامعلوم ","","0");
INSERT INTO customers VALUES("269","خلیل احمد نورزاده ","51879","3257129","پرزه فر.شی ها ","","0");
INSERT INTO customers VALUES("270","افتخار وفاه دوست سعید امیری","57190","26531","تیل فروشی ها","","0");
INSERT INTO customers VALUES("271","انجینر شاهین احمدی ","348719","25879123","شهرنو","","0");
INSERT INTO customers VALUES("272","علی احمد غفوری ","25387","235798","نامعلوم ","","0");
INSERT INTO customers VALUES("273","سید گل صراف فراهی ","31425879","578192","خراسان مارکت ","","0");
INSERT INTO customers VALUES("274","شکیب شادان شندند ","2385791","8357192","نامعلوم ","شندند","0");
INSERT INTO customers VALUES("278","حکمت","35226","0795887766","هرات افغانستان","شبیشیبشیب","0");
INSERT INTO customers VALUES("279","نوید ازدرک احواله سینانی","3467986","346739","هرات","احواله نعیم سینانی","0");
INSERT INTO customers VALUES("280","مهدی قربانی علاف","439603","39485034","مندی فرایا","","0");
INSERT INTO customers VALUES("281","آصف دانشیار ","349683","673984","باغدشت","","0");
INSERT INTO customers VALUES("282","نزیر احمد امیری ","68768","0980887","ترکیه","","0");
INSERT INTO customers VALUES("283","شرکت خورشید پور نور ناصر عرب زاده","34569","73568","باغدشت","","0");
INSERT INTO customers VALUES("284","انجینر محمد گل صراف معاون","9348597","317824561","رازی مادکت ","","0");
INSERT INTO customers VALUES("285","حاجی عزیز فیضی ","82759","829475","هرات","","0");
INSERT INTO customers VALUES("286","حبیب الله حبیب ترکمن","85793245","348745","هرات","","0");
INSERT INTO customers VALUES("287","طلب اکس تاریخ 1397/11/20","8579382","834796","نامعلوم ","","0");
INSERT INTO customers VALUES("288","صرافی نعمت الله فراهی ","486793","34876932","خراسان مارکت دوکان 190","","0");
INSERT INTO customers VALUES("289","صرافی روزبه ","329857","6872498","خراسان مارکت ","","0");
INSERT INTO customers VALUES("290","فتاح صراف","43583","23759","خراسان مارکت ","","0");
INSERT INTO customers VALUES("291","سید عبدالطیف","صراف","092350","خراسات مارکت 70","از احواله حبیب الرحمن","0");
INSERT INTO customers VALUES("292","نوید وفاه","وفاه","94739","تیل فروش ها","از احواله ناصر","0");
INSERT INTO customers VALUES("293","خانم سمین اکبری و توفیق اکبری","اکبری","856738","نامعلوم ","از احواله تواب اکبری","0");
INSERT INTO customers VALUES("294","فرید نعمانی","نعمانی","9347","نامعلوم ","احواله ها مهدی و محتبی","0");
INSERT INTO customers VALUES("295","صرافی سلیمی ","صراف","348579","خراسان مارکت ","از وکیل احمدحیدری","0");
INSERT INTO customers VALUES("296","کاکا سلطان احمد زراعت","زارعت","34896793","نامعلوم ","از احواله کابل","0");
INSERT INTO customers VALUES("297","مسعود یوسفی ","یوسفی ","83678","نامعلوم ","","0");
INSERT INTO customers VALUES("298","فضل احمد از احواله عظیمی","عظیمی","797243","نامعلوم ","از احواله عبدالرزاق عظیمی","0");
INSERT INTO customers VALUES("299","اسماعیل عظیمی","عظیمی","4387923","هرات","خودش","0");
INSERT INTO customers VALUES("300","عبدالکریم و عبدالحکیم صراف","صراف","83249579","2378568132","ازدرک متباقی دالر","0");
INSERT INTO customers VALUES("301","عبدالرحیم صراف عطایی","عطایی صراف","238570","خراسان مارکت ","","0");
INSERT INTO customers VALUES("302","محمود بختیاری","بختیاری","389254","ایران","","0");
INSERT INTO customers VALUES("303","مسعود توخی ","نوخی ","49346","المان","","0");
INSERT INTO customers VALUES("304","صرافی حاجی اسماعیل","صراف","3422662","خراسان مارکت ","","0");
INSERT INTO customers VALUES("305","فرید رفیق سعید امیری","رفیق سعید","34829609","نامعلوم","","0");
INSERT INTO customers VALUES("306","سلیمان خیل حمید الله حسینی","سلیمان خیل","78056","","","0");
INSERT INTO customers VALUES("307","حاجی حبیب الله غوری صراف","صراف","34945","خراسان مارکت ","","0");
INSERT INTO customers VALUES("308","حبیب الله صراف بین بازار","صراف","","خراسان مارکت ","","0");
INSERT INTO customers VALUES("309","ببرک همسایه صراف","صراف","3498250","","","0");
INSERT INTO customers VALUES("310","عبدالظاهر صدیقی ","صدیقی","349062","قالین فروشان","","0");
INSERT INTO customers VALUES("311","کد 863","نامعلوم","4032","نامعلوم ","به حساب سعید","0");
INSERT INTO customers VALUES("312","انجینر x از احواله داوود افضل","پرزه دارد","392860","هرات","","0");
INSERT INTO customers VALUES("313","انجینر میر سعید ","میر ","934256293","هرات","","0");
INSERT INTO customers VALUES("314","سید توفیق","اکبری ","340267","هرات","","0");
INSERT INTO customers VALUES("315","صدیق الله صدیقی بچه ماما","صدیقی ","93629","باغدشت","","0");
INSERT INTO customers VALUES("316","عبدالله باغدشتی","از احواله کابل","9386","باغدشت","","0");
INSERT INTO customers VALUES("317","صرافی آسمان ","صراف","3247596","خراسان مارکت ","","0");
INSERT INTO customers VALUES("318","اسحاق ناصری","صراف","3987602","خراسان مارکت ","","0");
INSERT INTO customers VALUES("319","عبدالغنی از احواله شجاع الدین","غنی","342093","هرت","","0");
INSERT INTO customers VALUES("320","شهیر حیدریار","حیدریار","37892653","هرات","","0");
INSERT INTO customers VALUES("321","متین خواهرزاده ","یوسفی ","93847539","","","0");
INSERT INTO customers VALUES("322","علی سینا شرزاد","شرزاد","32489706","هرات","","0");
INSERT INTO customers VALUES("323","جاوید کریمی پرزه ","پرزه دارد","75787898","هرات","","0");
INSERT INTO customers VALUES("324","نعمت ","نظری","","","","0");
INSERT INTO customers VALUES("325","xxxxxx","yyyyyyy","","","","0");



DROP TABLE IF EXISTS customerssell;

CREATE TABLE `customerssell` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerId` int(11) NOT NULL,
  `date` varchar(50) COLLATE utf8_persian_ci NOT NULL,
  `counterCurrency` int(11) NOT NULL,
  `baseAmount` int(11) NOT NULL,
  `amount` decimal(17,4) NOT NULL,
  `sellRate` decimal(17,4) NOT NULL,
  `buyRate` decimal(17,4) NOT NULL,
  `totalSell` decimal(17,4) NOT NULL,
  `totalBuy` decimal(17,4) NOT NULL,
  `baceCurrencyRate` decimal(17,4) NOT NULL,
  `dollartotalbuy` decimal(17,4) NOT NULL,
  `profit` decimal(17,4) NOT NULL,
  `dollarProfit` decimal(10,4) NOT NULL,
  `descr` text COLLATE utf8_persian_ci NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;




DROP TABLE IF EXISTS dailly;

CREATE TABLE `dailly` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `amount` decimal(17,2) NOT NULL,
  `price` decimal(17,2) NOT NULL,
  `buyId` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;




DROP TABLE IF EXISTS daily_transactions;

CREATE TABLE `daily_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currencyId` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `totalDollar` decimal(10,2) NOT NULL,
  `date` varbinary(50) NOT NULL,
  `priod` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS dailyasset;

CREATE TABLE `dailyasset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currencyId` int(11) NOT NULL,
  `amount` decimal(17,6) NOT NULL,
  `rate` decimal(17,6) NOT NULL,
  `dollarTotal` decimal(10,2) NOT NULL,
  `date` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS dailyprofit;

CREATE TABLE `dailyprofit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `totalAsset` decimal(10,2) NOT NULL,
  `dariyaft` decimal(15,4) NOT NULL,
  `pardakht` decimal(10,2) NOT NULL,
  `equity` decimal(10,2) NOT NULL,
  `date` varchar(60) COLLATE utf8_persian_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;




DROP TABLE IF EXISTS database_name;

CREATE TABLE `database_name` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_persian_ci NOT NULL,
  `year` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;




DROP TABLE IF EXISTS estimate;

CREATE TABLE `estimate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` decimal(17,4) NOT NULL,
  `currencyId` int(11) NOT NULL,
  `date` varchar(50) COLLATE utf8_persian_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;




DROP TABLE IF EXISTS expensesname;

CREATE TABLE `expensesname` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;

INSERT INTO expensesname VALUES("1","برق دوکان","0");
INSERT INTO expensesname VALUES("2","متفرقه","0");



DROP TABLE IF EXISTS incomename;

CREATE TABLE `incomename` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `incomeName` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;

INSERT INTO incomename VALUES("1","متفرقه","0");
INSERT INTO incomename VALUES("2","تفاوت ","0");



DROP TABLE IF EXISTS journal;

CREATE TABLE `journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(100) COLLATE utf8mb4_persian_ci NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_persian_ci NOT NULL,
  `currency` varchar(10) COLLATE utf8mb4_persian_ci NOT NULL,
  `reference` varchar(50) COLLATE utf8mb4_persian_ci NOT NULL,
  `reference_id` varchar(20) COLLATE utf8mb4_persian_ci NOT NULL,
  `amount` varchar(100) COLLATE utf8mb4_persian_ci NOT NULL,
  `threadment` varchar(20) COLLATE utf8mb4_persian_ci NOT NULL,
  `description` varchar(300) COLLATE utf8mb4_persian_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

INSERT INTO journal VALUES("1","1397-12-07","نعمت ","1","رسیدگی مشتری","1","200000","رسیدگی مشتری","");
INSERT INTO journal VALUES("2","1397-12-07","حکمت","1","بردگی مشتری","2","200000","بردگی مشتری","");
INSERT INTO journal VALUES("3","1397-12-08","نعمت ","1","رسیدگی مشتری","3","300000","رسیدگی مشتری","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO journal VALUES("4","1397-12-08","حکمت","1","بردگی مشتری","4","300000","بردگی مشتری","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO journal VALUES("5","1397-12-08","نعمت ","1","رسیدگی مشتری","5","300000","رسیدگی مشتری","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO journal VALUES("6","1397-12-08","حکمت","1","بردگی مشتری","6","300000","بردگی مشتری","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO journal VALUES("7","1397-12-08","نعمت ","1","رسیدگی مشتری","7","300000","رسیدگی مشتری","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO journal VALUES("8","1397-12-08","حکمت","1","بردگی مشتری","8","300000","بردگی مشتری","نقل از این حساب به به حساب اقای نعمت");
INSERT INTO journal VALUES("9","1397-12-08","فروش","2","فروش","1","1000","فروش","این مقدار را ما می فروشیم");
INSERT INTO journal VALUES("10","1397-12-08","فروش","2","فروش","3","1000","فروش","فروش دیگر ");
INSERT INTO journal VALUES("11","1397-12-08","فروش","2","فروش","5","200","فروش","ییییییی");
INSERT INTO journal VALUES("12","1397-12-08","فروش","2","فروش","7","100","فروش","ررررررررررررررر");
INSERT INTO journal VALUES("13","1397-12-08","فروش","2","فروش","9","100","فروش","ررررررررررررررر");
INSERT INTO journal VALUES("14","1397-12-08","فروش","2","فروش","11","100","فروش","ررررررررررررررر");
INSERT INTO journal VALUES("15","1397-12-08","xxxxxx","1","رسیدگی مشتری","9","20000","رسیدگی مشتری","");
INSERT INTO journal VALUES("16","1397-12-08","حکمت","1","بردگی مشتری","10","20000","بردگی مشتری","");



DROP TABLE IF EXISTS others;

CREATE TABLE `others` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(50) COLLATE utf8_persian_ci NOT NULL,
  `expensesId` int(11) NOT NULL,
  `currencyId` int(11) NOT NULL,
  `currencyAsset` decimal(10,4) NOT NULL,
  `amount` int(11) NOT NULL,
  `dollarRate` decimal(10,4) NOT NULL,
  `dollarTotal` decimal(10,4) NOT NULL,
  `typeOthers` int(11) NOT NULL,
  `description` text COLLATE utf8_persian_ci NOT NULL,
  `bank_id` int(11) NOT NULL,
  `remover` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;




DROP TABLE IF EXISTS transaction;

CREATE TABLE `transaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` varchar(100) COLLATE utf8_persian_ci NOT NULL,
  `counterCurrency` int(11) NOT NULL,
  `counterAmount` decimal(17,6) NOT NULL,
  `rate` decimal(17,6) NOT NULL,
  `baseCurrency` int(11) NOT NULL,
  `baseAmount` decimal(17,6) NOT NULL,
  `treatment` int(100) NOT NULL,
  `dollarRate` decimal(17,6) NOT NULL,
  `dollarTotal` decimal(17,6) NOT NULL,
  `extra` int(11) NOT NULL,
  `bank_id` int(11) NOT NULL,
  `bank_id_base` int(11) NOT NULL,
  `desc` text COLLATE utf8_persian_ci NOT NULL,
  `remove` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_persian_ci;

INSERT INTO transaction VALUES("1","1397-12-08","2","1000.000000","75.500000","1","75500.000000","2","0.000000","0.000000","0","0","0","این مقدار را ما می فروشیم","0");
INSERT INTO transaction VALUES("2","1397-12-08","2","1000.000000","75.500000","1","75500.000000","1","75.500000","75500.000000","1","0","0","این مقدار را ما می فروشیم","0");
INSERT INTO transaction VALUES("3","1397-12-08","2","1000.000000","75.500000","1","75500.000000","2","0.000000","0.000000","0","0","0","فروش دیگر ","0");
INSERT INTO transaction VALUES("4","1397-12-08","2","1000.000000","75.500000","1","75500.000000","1","75.500000","75500.000000","3","0","0","فروش دیگر ","0");
INSERT INTO transaction VALUES("5","1397-12-08","2","200.000000","75.500000","1","15100.000000","2","0.000000","0.000000","0","0","0","ییییییی","0");
INSERT INTO transaction VALUES("6","1397-12-08","2","200.000000","75.500000","1","15100.000000","1","75.500000","15100.000000","5","0","0","ییییییی","0");
INSERT INTO transaction VALUES("7","1397-12-08","2","100.000000","75.500000","1","7550.000000","2","0.000000","0.000000","0","0","0","ررررررررررررررر","0");
INSERT INTO transaction VALUES("8","1397-12-08","2","100.000000","75.500000","1","7550.000000","1","75.500000","7550.000000","7","0","0","ررررررررررررررر","0");
INSERT INTO transaction VALUES("9","1397-12-08","2","100.000000","75.500000","1","7550.000000","2","0.000000","0.000000","0","0","0","ررررررررررررررر","0");
INSERT INTO transaction VALUES("10","1397-12-08","2","100.000000","75.500000","1","7550.000000","1","75.500000","7550.000000","9","0","0","ررررررررررررررر","0");
INSERT INTO transaction VALUES("11","1397-12-08","2","100.000000","75.500000","1","7550.000000","2","0.000000","0.000000","0","0","0","ررررررررررررررر","0");
INSERT INTO transaction VALUES("12","1397-12-08","2","100.000000","75.500000","1","7550.000000","1","75.500000","7550.000000","11","0","0","ررررررررررررررر","0");



SET FOREIGN_KEY_CHECKS=1; 
